import express from 'express';
import cors from 'cors';
import { json, urlencoded } from 'express';
import { toNodeHandler } from 'better-auth/node';
import { auth as betterauth } from './lib/auth.js';
import locationsRoute from './routes/location.routes.js';
// Import routes
// import authRoutes from './routes/auth'
import emailRoutes from './routes/email.js';
import { initializeServices } from './services/serviceInit.js';
const app = express();
app.use(cors({
    origin: process.env.FRONTEND_URL || 'http://localhost:5000',
    credentials: true,
}));
// Initialize services
initializeServices().catch((err) => {
    console.error('Failed to initialize services:', err);
});
// Mount better-auth's built-in routes with correct syntax
app.all('/api/auth/{*any}', toNodeHandler(betterauth)); // BETTER AUTH
// Middleware
app.use(json());
app.use(urlencoded({ extended: true }));
// Mount our custom routes
// app.use('/api', authRoutes)
app.use('/api/email', emailRoutes);
// Basic route
app.get('/', (req, res) => {
    res.json({ message: 'Welcome to the API' });
});
app.get('/api/health', (req, res) => {
    res.json({ status: 'ok', timestamp: new Date().toISOString() });
});
app.use('/api/locations', locationsRoute);
// Error handling middleware
app.use((err, req, res, next) => {
    console.error(err.stack);
    res.status(500).json({
        error: {
            message: 'An unexpected error occurred',
            detail: process.env.NODE_ENV === 'development' ? err.message : undefined,
        },
    });
});
// Export the app for use in server.ts
export default app;
//# sourceMappingURL=app.js.map