import { betterAuth } from 'better-auth';
import { prismaAdapter } from 'better-auth/adapters/prisma';
import { openAPI } from 'better-auth/plugins';
import emailService from './emailService.js';
import { prisma as db } from './prismaClient.js';
export const auth = betterAuth({
    baseURL: process.env.APP_URL || 'http://localhost:5002',
    database: prismaAdapter(db, {
        provider: 'postgresql', // or "postgres"
    }),
    emailAndPassword: {
        enabled: true,
        autoSignIn: true,
        requireEmailVerification: false,
        // You control the email template & link
        sendResetPassword: async ({ user, url, token }, req) => {
            await emailService.sendPasswordResetEmail(user.email, url, token);
            // await sendEmail({
            //   to: user.email,
            //   subject: 'Reset your password',
            //   text: `Click to reset your password: ${url}`,
            //   html: `<p>Click to reset your password: <a href="${url}">${url}</a></p>`,
            // })
        },
    },
    //   socialProviders: {
    //     github: {
    //       clientId: process.env.GITHUB_CLIENT_ID as string,
    //       clientSecret: process.env.GITHUB_CLIENT_SECRET as string,
    //     },
    //     google: {
    //       clientId: process.env.GOOGLE_CLIENT_ID as string,
    //       clientSecret: process.env.GOOGLE_CLIENT_SECRET as string,
    //     },
    //     // Add more providers as needed
    //   },
    session: {
        expiresIn: 60 * 60 * 24 * 30, // 30 days (remember me)
        updateAge: 60 * 60 * 24, // bump expiry at most once per day on activity
    },
    user: {
        additionalFields: {
            // Add any additional user fields you need
            role: {
                type: 'string',
                input: false,
                defaultValue: 'user',
            },
            avatar: {
                type: 'string',
                required: false,
            },
            firstName: {
                type: 'string',
                required: false,
            },
            lastName: {
                type: 'string',
                required: false,
            },
        },
    },
    trustedOrigins: [process.env.FRONTEND_URL || 'http://localhost:5000', process.env.APP_URL || 'http://localhost:8000'],
    secret: process.env.BETTER_AUTH_SECRET,
    advanced: {
        generateId: () => crypto.randomUUID(), // Use built-in crypto for ID generation
        crossSubDomainCookies: {
            enabled: true, // Set to true if you need cross-subdomain support
        },
    },
    plugins: [
        openAPI({
        // path: '/docs',
        // stripBasePath: true, // Add this to ensure paths are correctly generated
        }),
        // Add plugins as needed
        // Example: twoFactor(), adminPlugin(), etc.
    ],
});
//# sourceMappingURL=auth.js.map