import dotenv from 'dotenv';
// Load environment variables from .env file
dotenv.config();
import app from './app.js';
const PORT = process.env.PORT || 5002;
const server = app.listen(PORT, () => {
    console.log(`Server is running on port ${PORT}`);
});
// Handle graceful shutdown
process.on('SIGTERM', () => {
    console.log('SIGTERM signal received: closing HTTP server');
    server.close(() => {
        console.log('HTTP server closed');
    });
});
export default server;
//# sourceMappingURL=server.js.map