import { prisma } from '../lib/prismaClient.js';
// Use a cache to store zip codes we've already looked up
const cache = new Map();
/**
 * Load all zip codes into the cache
 */
export async function loadAllZips() {
    const zipCodes = await prisma.zipCode.findMany();
    zipCodes.forEach((zipCode) => cache.set(zipCode.zip, zipCode));
}
/**
 * Get a zip code by its code
 * @param zip The zip code to look up
 * @returns The zip code object if found, undefined otherwise
 */
export async function getZip(zip) {
    // Check cache first
    const hit = cache.get(zip);
    if (hit)
        return hit;
    // If not in cache, query from database
    const zipCode = await prisma.zipCode.findUnique({
        where: { zip },
    });
    // Cache the result if found
    if (zipCode)
        cache.set(zip, zipCode);
    return zipCode;
}
//# sourceMappingURL=zipcode.service.js.map